#!/bin/bash

old_exec="/opt/kryptet/kryptet";

# Warn if old package is still installed
if test -e "${old_exec}"; then
  echo "WARNING: It seems that there are files from the old kryptet package on"
  echo "your machine. We highly recommend that you remove the old version"
  echo "and then reinstall this package. You can remove the old package with"
  echo "the following command:"
  echo "sudo apt-get remove kryptet"
fi

# Clean up old invalid links
if [ -L '/usr/local/bin/kryptet' ] || [ -L '/usr/local/bin/<%= executable %>' ]; then
  echo "Removing old invalid symlinks"
  if [ -L '/usr/local/bin/kryptet' ] && [ "$(readlink '/usr/local/bin/kryptet')" = "${old_exec}" ]; then rm -f /usr/local/bin/kryptet; fi
  if [ -L '/usr/local/bin/<%= executable %>' ] && [ "$(readlink '/usr/local/bin/<%= executable %>')" = '/opt/<% productFilename %>/<%= executable %>' ]; then rm -f '/usr/local/bin/<%= executable %>'; fi
fi

# Link to the binary
ln -sf '/opt/${productFilename}/${executable}' '/usr/bin/${executable}'
