"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var fs = require("fs");
var image_type_1 = require("image-type");
var moment = require("moment");
exports.downloadImage = function (bytes, timestamp) {
    return new Promise(function (resolve, reject) {
        var type = image_type_1.default(bytes);
        var options = {};
        var dateObj = new Date(Number(timestamp));
        if (dateObj.getTime() && !isNaN(dateObj.getTime())) {
            var momentObj = moment(dateObj);
            var filename = "Kryptet " + momentObj.format('YYYY-MM-DD') + " at " + momentObj.format('H.mm.ss');
            options.defaultPath = filename;
        }
        if (type && type.ext) {
            options.filters = [
                {
                    extensions: [type.ext],
                    name: 'Images',
                },
            ];
            options.defaultPath += "." + type.ext;
        }
        electron_1.dialog.showSaveDialog(options, function (chosenPath) {
            if (chosenPath) {
                fs.writeFile(chosenPath, new Buffer(bytes.buffer), function (error) { return (error ? reject(error) : resolve()); });
            }
        });
    });
};
//# sourceMappingURL=download.js.map