"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("@wireapp/commons");
var electron_1 = require("electron");
var config_1 = require("../settings/config");
var mainProcess = electron_1.remote ? electron_1.remote.process : process;
var isDevelopment = config_1.config.environment !== 'production';
var forceLogging = mainProcess.argv.includes('--enable-logging');
exports.LOGGER_NAMESPACE = '@wireapp/desktop';
exports.ENABLE_LOGGING = isDevelopment || forceLogging;
function getLogger(name) {
    var options = {
        namespace: exports.LOGGER_NAMESPACE,
        separator: '/',
    };
    if (exports.ENABLE_LOGGING) {
        options.forceEnable = true;
    }
    return commons_1.LogFactory.getLogger(name, options);
}
exports.getLogger = getLogger;
//# sourceMappingURL=getLogger.js.map