/*
 * kryptet
 */

import {ActionType, addAccount, deleteAccount, switchAccount, updateAccount, updateAccountBadge} from '../';
import uuid from 'uuid/v4';

describe('action creators', () => {
  describe('addAccount', () => {
    it('should create action to add account with session', () => {
      const action = addAccount();
      expect(action.type).toEqual(ActionType.ADD_ACCOUNT);
      expect(action.sessionID).toEqual(expect.any(String));
    });
  });

  describe('updateAccount', () => {
    it('should create action to update account', () => {
      const id = uuid();
      const data = {name: 'Foo'};
      const action = {
        data,
        id,
        type: ActionType.UPDATE_ACCOUNT,
      };
      expect(updateAccount(id, data)).toEqual(action);
    });
  });

  describe('switchAccount', () => {
    it('should create action to switch account', () => {
      const id = uuid();
      const action = {
        id,
        type: ActionType.SWITCH_ACCOUNT,
      };
      expect(switchAccount(id)).toEqual(action);
    });
  });

  describe('updateAccountBadge', () => {
    it('should create action to update account badge', () => {
      const id = uuid();
      const count = 42;
      const action = {
        count,
        id,
        type: ActionType.UPDATE_ACCOUNT_BADGE,
      };
      expect(updateAccountBadge(id, count)).toEqual(action);
    });
  });

  describe('deleteAccount', () => {
    it('should create action to delete an account', () => {
      const id = uuid();
      const action = {
        id,
        type: ActionType.DELETE_ACCOUNT,
      };
      expect(deleteAccount(id)).toEqual(action);
    });
  });
});
