/*
 * kryptet
 */

import './App.css';
import * as EVENT_TYPE from '../lib/eventType';
import {initiateSSO, switchAccount, updateAccount} from '../actions';
import IsOnline from './IsOnline';
import React from 'react';
import Sidebar from './Sidebar';
import WebviewsContainer from '../containers/WebviewsContainer';
import {config} from '../../../dist/settings/config';
import {connect} from 'react-redux';

class App extends React.Component {
  constructor(props) {
    super(props);

    this.switchAccount = this.switchAccount.bind(this);
    this.initiateSSO = this.initiateSSO.bind(this);
  }

  componentDidMount() {
    window.addEventListener(EVENT_TYPE.ACTION.SWITCH_ACCOUNT, this.switchAccount, false);
    window.addEventListener(EVENT_TYPE.ACTION.CREATE_SSO_ACCOUNT, this.initiateSSO, false);
  }

  componentWillUnmount() {
    window.removeEventListener(EVENT_TYPE.ACTION.SWITCH_ACCOUNT, this.switchAccount);
    window.removeEventListener(EVENT_TYPE.ACTION.CREATE_SSO_ACCOUNT, this.initiateSSO);
  }

  switchAccount(event) {
    const {accountIndex} = event.detail;
    const accountId = this.props.accountIds[accountIndex];
    if (accountId) {
      this.props.switchAccount(accountId);
    }
  }

  initiateSSO(event) {
    const loggedOutWebviews = this.props.accounts.filter(account => account.userID === undefined);
    const ssoCode = event.detail.code;

    if (loggedOutWebviews.length > 0) {
      const accountId = loggedOutWebviews[0].id;
      this.props.switchAccount(accountId);
      this.props.initiateSSO(accountId, ssoCode, this.props.accounts.length == 1);
    } else {
      if (this.props.accounts.length >= config.maximumAccounts) {
        return window.dispatchEvent(
          new CustomEvent(EVENT_TYPE.ACTION.CREATE_SSO_ACCOUNT_RESPONSE, {
            detail: {
              reachedMaximumAccounts: true,
            },
          }),
        );
      }
      // All accounts are logged in, create a new one
      this.props.initiateSSO(undefined, ssoCode, true);
    }
    window.dispatchEvent(new CustomEvent(EVENT_TYPE.ACTION.CREATE_SSO_ACCOUNT_RESPONSE));
  }

  render() {
    return (
      <IsOnline>
        <div className="App">
          <Sidebar />
          <WebviewsContainer />
        </div>
      </IsOnline>
    );
  }
}

function mapStateToProps(state) {
  const {accounts} = state;
  return {
    accountIds: accounts.map(account => account.id),
    accounts,
    isAddingAccount: !!accounts.length && accounts.some(account => account.userID === undefined),
  };
}

function mapDispatchToProps() {
  return {initiateSSO, switchAccount, updateAccount};
}

export default connect(
  mapStateToProps,
  mapDispatchToProps(),
)(App);
