/*
 * kryptet
 */

import './Webview.css';

import React, {Component} from 'react';

export default class Webview extends Component {
  constructor(props) {
    super(props);

    this._onIpcMessage = this._onIpcMessage.bind(this);
  }

  componentDidMount() {
    const {src, partition} = this.props;

    // set unknown props
    // see: https://facebook.github.io/react/warnings/unknown-prop.html
    // see: https://github.com/electron/electron/issues/6046
    this.webview.partition = partition ? `persist:${partition}` : '';
    this.webview.src = src;

    this.webview.addEventListener('ipc-message', this._onIpcMessage);

    this.webview.addEventListener('dom-ready', event => {
      this._focusWebview();
    });
  }

  componentDidUpdate() {
    this._focusWebview();
  }

  shouldComponentUpdate(nextProps) {
    if (nextProps.visible) {
      this._focusWebview();
    }
    return this.props.visible !== nextProps.visible;
  }

  _onIpcMessage(event) {
    this.props.onIpcMessage(event);
  }

  _focusWebview() {
    if (this.props.visible && this.webview) {
      this.webview.blur();
      this.webview.focus();
      this.webview.getWebContents().webContents.focus();
    }
  }

  render() {
    const {visible, partition, src, onPageTitleUpdated, onIpcMessage, ...validProps} = this.props; // eslint-disable-line no-unused-vars
    return <webview {...validProps} ref={webview => (this.webview = webview)} />;
  }
}
