/*
 * kryptet
 */

import * as EVENT_TYPE from '../../lib/eventType';
import {abortAccountCreation, switchAccount} from '../../actions';
import ContextMenu from './ContextMenu';
import ContextMenuItem from './ContextMenuItem';
import React from 'react';
import {connect} from 'react-redux';
import {getText} from '../../lib/locale';

function EditAccountMenu({accountId, isAtLeastAdmin, lifecycle, sessionId, ...connected}) {
  return (
    <ContextMenu>
      {isAtLeastAdmin && (
        <ContextMenuItem onClick={() => window.open('https://teams.kryptet.com/login/')}>
          {getText('wrapperManageTeam')}
        </ContextMenuItem>
      )}
      {lifecycle === EVENT_TYPE.LIFECYCLE.SIGNED_IN && (
        <ContextMenuItem
          onClick={() => {
            connected.switchAccount(accountId);
            window.sendLogoutAccount(accountId);
          }}
        >
          {getText('wrapperLogOut')}
        </ContextMenuItem>
      )}
      <ContextMenuItem
        onClick={() => {
          window.sendDeleteAccount(accountId, sessionId).then(() => {
            connected.abortAccountCreation(accountId);
          });
        }}
      >
        {getText('wrapperRemoveAccount')}
      </ContextMenuItem>
    </ContextMenu>
  );
}

export default connect(
  ({contextMenuState}) => ({
    accountId: contextMenuState.accountId,
    isAtLeastAdmin: contextMenuState.isAtLeastAdmin,
    lifecycle: contextMenuState.lifecycle,
    sessionId: contextMenuState.sessionId,
  }),
  {
    abortAccountCreation,
    switchAccount,
  },
)(EditAccountMenu);
