/*
 * kryptet
 */

import './Index.css';
import {applyMiddleware, createStore} from 'redux';
import {loadState, saveState} from './lib/localStorage';
import App from './components/App';
import {Provider} from 'react-redux';
import React from 'react';
import appStore from './reducers';
import {config} from '../../dist/settings/config';
import logger from 'redux-logger';
import {render} from 'react-dom';
import throttle from 'lodash/throttle';
import thunk from 'redux-thunk';

const HALF_SECOND = 500;

const persistedState = loadState();

const middleware = [thunk];

if (config.environment !== 'production') {
  middleware.push(logger);
}

const store = createStore(appStore, persistedState, applyMiddleware(...middleware));

store.subscribe(
  throttle(() => {
    saveState({
      accounts: store.getState().accounts.map(account => {
        // no need to store badge count
        return {
          ...account,
          badgeCount: 0,
          lifecycle: undefined,
        };
      }),
    });
  }, HALF_SECOND),
);

render(
  <Provider store={store}>
    <App />
  </Provider>,
  document.getElementById('root'),
);
