/*
 * kryptet
 */

/* eslint-disable no-magic-numbers */

import {verifyObjectProperties} from '../verifyObjectProperties';

describe('verifyObjectProperties', () => {
  it('should return the object if object contains all properties specified in the config', () => {
    const obj = {
      bla: 2,
      foo: 'test',
    };

    const config = {
      bla: 'Number',
      foo: 'String',
    };

    const validatedObject = verifyObjectProperties(obj, config);
    expect(validatedObject).toBeTruthy();
    expect(Object.keys(validatedObject).length).toBe(2);
  });

  it('should return the object with defaults if object contains only a subset of properties specified in the config', () => {
    const obj = {
      bla: 2,
    };

    const config = {
      bla: 'Number',
      foo: 'String',
      some: 'Number',
    };

    const validatedObject = verifyObjectProperties(obj, config);
    expect(validatedObject).toBeTruthy();
    expect(Object.keys(validatedObject).length).toBe(3);
    expect(validatedObject.foo).toBe('');
    expect(validatedObject.some).toBeUndefined();
  });

  it('should return only the expected properties if object contains properties in addition to the expected config', () => {
    const obj = {
      bla: 2,
      foo: '3',
      mistake: 'I should not be here',
    };

    const config = {
      bla: 'Number',
      foo: 'String',
    };

    const validatedObject = verifyObjectProperties(obj, config);
    expect(validatedObject).toBeTruthy();
    expect(Object.keys(validatedObject).length).toBe(2);
    expect(validatedObject.foo).toBe('3');
    expect(validatedObject.mistake).toBeUndefined();
  });

  it('should return false if object contains a property with a wrong type', () => {
    const obj = {
      bla: 2,
      foo: 1,
    };

    const config = {
      bla: 'Number',
      foo: 'String',
    };

    expect(verifyObjectProperties(obj, config)).toBeFalsy();
  });

  it('should return false if object contains a property with undefined but config excepted a type', () => {
    const obj = {
      bla: 2,
      foo: undefined,
    };

    const config = {
      bla: 'Number',
      foo: 'String',
    };

    expect(verifyObjectProperties(obj, config)).toBeFalsy();
  });
});
