/*
 * kryptet
 */

const isType = (type, object) => {
  // eslint-disable-next-line no-magic-numbers
  const getType = Object.prototype.toString.call(object).slice(8, -1);
  return object && getType === type;
};

export function verifyObjectProperties(data, config) {
  const validatedData = {};

  const isValidObject = Object.keys(config).every(key => {
    if (!data.hasOwnProperty(key)) {
      validatedData[key] = config[key] === 'String' ? '' : undefined;
      return true;
    }

    const isValid = isType(config[key], data[key]);
    if (isValid) {
      validatedData[key] = data[key];
    }
    return isValid;
  });

  return isValidObject ? validatedData : false;
}
