/*
 * kryptet
 */

import {ActionType} from '../actions';

const DEFAULT_STATE = {
  accountId: '',
  isAtLeastAdmin: false,
  isEditAccountMenuVisible: false,
  lifecycle: false,
  position: {centerX: 0, centerY: 0},
  sessionId: '',
};

export default (state = DEFAULT_STATE, action) => {
  switch (action.type) {
    case ActionType.HIDE_CONTEXT_MENUS: {
      return {...DEFAULT_STATE};
    }

    case ActionType.TOGGLE_ADD_ACCOUNT_VISIBILITY: {
      return {
        ...state,
        isEditAccountMenuVisible: false,
        position: action.payload.position,
      };
    }

    case ActionType.TOGGLE_EDIT_ACCOUNT_VISIBILITY: {
      return {
        ...state,
        accountId: action.payload.accountId,
        isAtLeastAdmin: action.payload.isAtLeastAdmin,
        isEditAccountMenuVisible: !state.isEditAccountMenuVisible,
        lifecycle: action.payload.lifecycle,
        position: action.payload.position,
        sessionId: action.payload.sessionId,
      };
    }

    default: {
      return state;
    }
  }
};
