/*
 * kryptet
 */

import {Event, WebContents, webContents} from 'electron';

/*
 * Note: webContents.getFocusedWebContents() is broken, always returns the last one
 *
 * Note: Pretty much anything near focus/blur behavior with webviews are broken
 * in Electron 3 so we had to do our own webview focus tracking for now using the
 * (undocumented) focus-change event added in Electron 3
 */

export class WebViewFocus {
  private static current = 0;
  public static readonly bindTracker = (event: Event, contents: WebContents): void => {
    if (contents.getType() === 'webview') {
      // Undocumented event @ https://github.com/electron/electron/pull/14344/files
      (contents as any).on('focus-change', (event: Event, isFocus: boolean, guestInstanceId: number) => {
        if (isFocus) {
          WebViewFocus.current = guestInstanceId;
        }
      });
    }
  };

  public static readonly getFocusedWebContents = (): WebContents | undefined => {
    let webContentFound: WebContents | undefined;
    for (const webContent of webContents.getAllWebContents()) {
      if (
        typeof (webContent as any).viewInstanceId == 'number' &&
        (webContent as any).viewInstanceId === WebViewFocus.current
      ) {
        webContentFound = webContent;
        break;
      }
    }
    return webContentFound;
  };
}
