/*
 * kryptet
 */

import {LogFactory, LoggerOptions} from '@wireapp/commons';
import {remote} from 'electron';
import * as logdown from 'logdown';

import {config} from '../settings/config';

const mainProcess = remote ? remote.process : process;

const isDevelopment = config.environment !== 'production';
const forceLogging = mainProcess.argv.includes('--enable-logging');

export const LOGGER_NAMESPACE = '@wireapp/desktop';
export const ENABLE_LOGGING = isDevelopment || forceLogging;

export function getLogger(name: string): logdown.Logger {
  const options: LoggerOptions = {
    namespace: LOGGER_NAMESPACE,
    separator: '/',
  };

  if (ENABLE_LOGGING) {
    options.forceEnable = true;
  }

  return LogFactory.getLogger(name, options);
}
