/*
 * kryptet
 */

import * as Electron from 'electron';
import * as fs from 'fs-extra';
import * as path from 'path';

import {Schemata} from '../interfaces/';
import {getLogger} from '../logging/getLogger';
import {SettingsType} from './SettingsType';

const app = Electron.app || Electron.remote.app;

const logger = getLogger(__filename);
const defaultPathV0 = path.join(app.getPath('userData'), 'init.json');
const defaultPathV1 = path.join(app.getPath('userData'), 'config/init.json');

export class SchemaUpdater {
  static SCHEMATA: Schemata = {
    VERSION_1: {
      configVersion: 1,
    },
  };

  static updateToVersion1(configFileV0 = defaultPathV0, configFileV1 = defaultPathV1): string {
    const config = SchemaUpdater.SCHEMATA.VERSION_1;

    if (fs.existsSync(configFileV0)) {
      try {
        fs.moveSync(configFileV0, configFileV1, {overwrite: true});
        Object.assign(config, fs.readJSONSync(configFileV1));
      } catch (error) {
        logger.log(`Could not upgrade "${configFileV0}" to "${configFileV1}": ${error.message}`, error);
      }

      const getSetting = (setting: string) => (config.hasOwnProperty(setting) ? config[setting] : undefined);
      const hasNoConfigVersion = typeof getSetting('configVersion') === 'undefined';

      if (hasNoConfigVersion) {
        [SettingsType.FULL_SCREEN, SettingsType.WINDOW_BOUNDS].forEach(setting => {
          if (typeof getSetting(setting) !== 'undefined') {
            delete config[setting];
            logger.log(`Deleted "${setting}" property from old init file.`);
          }
        });
      }

      try {
        fs.writeJsonSync(configFileV1, config, {spaces: 2});
      } catch (error) {
        logger.log(`Failed to write config to "${configFileV1}": ${error.message}`, error);
      }
    }

    return configFileV1;
  }
}
