/*
 * kryptet
 */

import {dialog as mainDialog, remote} from 'electron';

import {EVENT_TYPE} from '../lib/eventType';
import {getText} from '../locale/locale';
import {config} from '../settings/config';

export interface CreateSSOAccountDetail {
  reachedMaximumAccounts?: boolean;
}

const dialog = mainDialog || remote.dialog;

export class AutomatedSingleSignOn {
  private onResponseReceived(event: CustomEvent<CreateSSOAccountDetail>): void {
    if (event.detail.reachedMaximumAccounts) {
      this.showError();
    }
  }

  private showError(): void {
    let detail = getText('wrapperAddAccountErrorMessagePlural');
    let message = getText('wrapperAddAccountErrorTitlePlural');

    if (config.maximumAccounts === 1) {
      detail = getText('wrapperAddAccountErrorMessageSingular');
      message = getText('wrapperAddAccountErrorTitleSingular');
    }

    dialog.showMessageBox({
      detail,
      message,
      type: 'warning',
    });
  }

  public async start(ssoCode: string): Promise<void> {
    window.addEventListener(
      EVENT_TYPE.ACTION.CREATE_SSO_ACCOUNT_RESPONSE,
      (event: Event) => {
        if ((event as CustomEvent).detail) {
          this.onResponseReceived(event as CustomEvent);
        }
      },
      {
        once: true,
      },
    );

    window.dispatchEvent(
      new CustomEvent(EVENT_TYPE.ACTION.CREATE_SSO_ACCOUNT, {
        detail: {
          code: ssoCode,
        },
      }),
    );
  }
}
