/*
 * kryptet
 */

import {BrowserWindow, app} from 'electron';

let primaryWindowId: number | undefined;

const getPrimaryWindow = () => {
  const [primaryWindow] = primaryWindowId ? [BrowserWindow.fromId(primaryWindowId)] : BrowserWindow.getAllWindows();
  return primaryWindow;
};

const setPrimaryWindowId = (newPrimaryWindowId: number): void => {
  primaryWindowId = newPrimaryWindowId;
};

const showPrimaryWindow = (): void => {
  const browserWindow = getPrimaryWindow();

  if (browserWindow) {
    if (browserWindow.isMinimized()) {
      browserWindow.restore();
    } else if (!browserWindow.isVisible()) {
      browserWindow.show();
    }

    browserWindow.focus();
  }
};

const sendActionToPrimaryWindow = (channel: string, ...args: any[]): void => {
  const primaryWindow = getPrimaryWindow();
  if (primaryWindow) {
    primaryWindow.webContents.send(channel, ...args);
  }
};

const sendActionAndFocusWindow = async (channel: string, ...args: any[]) => {
  await app.whenReady();
  const main = getPrimaryWindow();
  if (main.webContents.isLoading()) {
    main.webContents.once('did-finish-load', () => {
      main.webContents.send(channel, ...args);
    });
  } else {
    if (!main.isVisible()) {
      main.show();
      main.focus();
    }
    main.webContents.send(channel, ...args);
  }
};

export const WindowManager = {
  getPrimaryWindow,
  sendActionAndFocusWindow,
  sendActionToPrimaryWindow,
  setPrimaryWindowId,
  showPrimaryWindow,
};
