/*
 * kryptet
 */

import {BrowserWindow, screen} from 'electron';

type Rectangle = {
  height: number;
  width: number;
  x: number;
  y: number;
};

const pointInRectangle = (point: [number, number], rectangle: Rectangle) => {
  const [x, y] = point;
  const xInRange = x >= rectangle.x && x <= rectangle.x + rectangle.width;
  const yInRange = y >= rectangle.y && y <= rectangle.y + rectangle.height;

  return xInRange && yInRange;
};

const isInView = (win: BrowserWindow): boolean => {
  const windowBounds = win.getBounds();
  const nearestWorkArea = screen.getDisplayMatching(windowBounds).workArea;

  const upperLeftVisible = pointInRectangle([windowBounds.x, windowBounds.y], nearestWorkArea);
  const lowerRightVisible = pointInRectangle(
    [windowBounds.x + windowBounds.width, windowBounds.y + windowBounds.height],
    nearestWorkArea,
  );

  return upperLeftVisible || lowerRightVisible;
};

export const WindowUtil = {pointInRectangle, isInView};
